/*
   Mesure d'une tension comprise entre 0 et 12V
   LAURENT Stéphane - Lycée valin (17)
   31/08/2025
*/

float tempsPrecedent = 0;
const float intervalle = 5;       // durée entre deux mesures en ms
float date = 0;                   // date de la mesure
const float calibration = 1.000;  // modifier le coefficient de calibration si nécessaire
float tension = 0;                // tension mesurée
float valeurLue = 0;              // valeur lue sur l'entrée A0
float sommeValeurLue = 0;         // somme de toutes les mesures  sur l'entrée A0
int nbrValeur = 0;                // Nombre de mesures sur l'entrée A0

void setup() {

  // Initialise la communication avec le PC
  Serial.begin(115200);

  // Utilisation de la tension de référence interne de 1.1V
  analogReference(INTERNAL);

  Serial.println("Ok");  // Envoyé au PC pour l'informer que l'initialisation est terminée
  delay(500);
}


void loop() {
  
  unsigned long tempsCourant = millis();  // cette variable contient le nombre de millisecondes depuis que le programme a démarré.
  
  // pour faire la moyenne des mesures
  valeurLue = analogRead(A0);  // Mesure la tension sur la broche A0 (de 0 à 1023)
  sommeValeurLue += valeurLue;
  nbrValeur += 1;

  if (tempsCourant - tempsPrecedent >= intervalle) {
    tempsPrecedent = tempsCourant;

    // mise à jour de la date
    date = date + intervalle;

    // envoie la date sur la liaison série
    Serial.print(round(date));
    Serial.print(" ");  // les données sont séparées par des espaces.

    // Faire la moyenne des valeurs mesurées et transformer valeurLue en tension comprise entre 0 et 1,1 V
    tension = (sommeValeurLue / nbrValeur) * 1.1 / 1023;
    
    // Envoie la mesure au PC en tenant compte du pont diviseur de tension et de la calibration
    Serial.println(tension * 11 * calibration);  // (R1 + R2)/R2 = 11
    
    // remise à zéro pour les mesures sur A0
    sommeValeurLue = 0;
    nbrValeur = 0;
  }
  
}
