/*
    pH-mètre du lycée Valin (17)

   Ce code est une adaptation de l'exemple fourni pour la sonde pH-métrique Gravity : Analog pH Sensor / Meter Kit V2, SKU:SEN0161-V2
   
   https://github.com/DFRobot/DFRobot_PH
   Copyright   [DFRobot](http://www.dfrobot.com), 2018
   Copyright   GNU Lesser General Public License
   version  V1.0
   date  2018-04
   
   Les commandes à saisir dans le moniteur série pour réaliser l'étalonnage sont :
   
     enterph -> entrer dans le mode d'étalonnage 
     calph   -> étalonner avec la solution tampon standard, deux solutions tampons (4.0 et 7.0) seront automatiquement reconnues 
     exitph  -> enregistrer les paramètres calibrés et sortir du mode calibrage 

   La valeur du pH est afficher sur le moniteur série et sur un écran LCD I2C (non Grove).

*/

#include "DFRobot_PH.h"
#include <EEPROM.h>
#include <LiquidCrystal_I2C.h>

/* Ecran LCD  */
LiquidCrystal_I2C lcd(0x27, 16, 2); // adresse i2c , nombre de colonnes, nombre de lignes de l'écran

#define PH_PIN A0
float voltage, phValue, temperature = 20;  // température par défaut
DFRobot_PH ph;

void setup()
{
  Serial.begin(115200);
  ph.begin();

  lcd.init();   // initialisation du LCD
  lcd.backlight();   // active le rétroéclairage

  // Ecrire un message d'accueil sur l'écran LCD
  lcd.clear();   // effacer l'écran
  lcd.setCursor(4,0);   // mettre le curseur à la quatrième colonne, première ligne
  lcd.print("pH-metre"); 
  lcd.setCursor(3,1);   // mettre le curseur à la deuxième colonne, deuxième ligne
  lcd.print("Lycee Valin");
  delay(4000);
}

void loop()
{
  static unsigned long timepoint = millis();
  if (millis() - timepoint > 1000U) {            //une mesure toutes les 1s
    timepoint = millis();

    voltage = analogRead(PH_PIN) / 1024.0 * 5000; // lire la tension
    phValue = ph.readPH(voltage, temperature); // convertir la tension en pH avec compensation de la température
    
    /* Affiche le pH sur le moniteur série */
    Serial.print("pH = ");
    Serial.println(phValue, 2);

    /* Affiche le pH sur l'écran lcd */
    lcd.clear();   // effacer l'écran
    lcd.setCursor(4, 0);  // mettre le curseur à la cinquième colonne, première ligne
    lcd.print("pH = ");
    lcd.print(phValue, 1);
    

  }
  ph.calibration(voltage, temperature);          // processus d'étalonnage 
}
