/**
   Mesures de températures avec deux capteurs DS18B20 GROVE
   Les mesures sont envoyées sur la liaison série et affichées sur un écran LCD Grove
   © Stéphane LAURENT Lycée Valin (17)
*/

/* Inclure les bibliothèques */
#include <OneWire.h>
#include <DallasTemperature.h>
#include "rgb_lcd.h"

/* Création de l'objet OneWire et sensors */

OneWire capteur1(5);  // Création d'un objet One Wire sur la broche D5  => température T1
OneWire capteur2(6);  // Création d'un objet One Wire sur la broche D6  => température T2

DallasTemperature sensors1(&capteur1);   // Indiquer la référence OneWire à la bibliothèque Dallas Temperature.
DallasTemperature sensors2(&capteur2);

/* Ecran LCD GROVE */
rgb_lcd lcd;

/* Pour faire des mesures à intervalle régulier */
unsigned long tempsPrecedent = 0;
unsigned long date = 0;   // date de la mesure
float intervalle = 2000;  // durée entre deux mesures en ms

/* Calibration des thermomètres (facultatif) */
float calibration1 = 0;  // valeur de la calibration du thermomètre 1
float calibration2 = 0;  // valeur de la calibration du thermomètre 2

void setup() {

  /* Ecran LCD  */
  lcd.begin(16, 2);            // Définir le nombre de colonnes et de lignes de l'écran LCD
  lcd.print("  Thermometre");  //affichage d'un message sur l'ecran
  lcd.setCursor(0, 1);         // mettre le curseur à la première colonne, deuxième ligne
  lcd.print("Lycee Valin (17)");

  Serial.begin(115200);  // choix de la vitesse

  sensors1.begin();
  sensors2.begin();

  Serial.println("Ok");  // envoyé à l'interface graphique pour l'informer que l'initialisation est terminée
  delay(100);
  Serial.println(2);    // indique à l'interface graphique le nombre de thermomètres
  delay(100);
}

void loop() {
  unsigned long tempsCourant = millis();  

  if (tempsCourant - tempsPrecedent >= intervalle) {
    tempsPrecedent = tempsCourant;

    /* Demande la température aux capteurs */

    sensors1.requestTemperatures();
    float temperature_1 = sensors1.getTempCByIndex(0) + calibration1;  // obtenir la température T1 en degré

    sensors2.requestTemperatures();
    float temperature_2 = sensors2.getTempCByIndex(0) + calibration2;  // obtenir la température T2 en degré

    /* envoie la date sur la liaison série  */
    Serial.print(date);
    Serial.print(" ");  // les données sont séparées par des espaces.

    /* envoie les températures sur la liaison série  */

    Serial.print(int(temperature_1 * 10));
    Serial.print(" ");  // les données sont séparées par des espaces.
    Serial.println(int(temperature_2 * 10));

    /* Affiche les températures sur l'écran lcd */

    lcd.clear();  // effacer l'écran
    lcd.setCursor(2, 0);  // mettre le curseur à la troisième colonne, première ligne
    lcd.print("T1 = ");
    lcd.print(temperature_1, 1);
    lcd.print(" ");
    lcd.print((char)223);  // symbole °
    lcd.print("C");

    lcd.setCursor(2, 1);  // mettre le curseur à la troisième colonne, deuxième ligne
    lcd.print("T2 = ");
    lcd.print(temperature_2, 1);
    lcd.print(" ");
    lcd.print((char)223);
    lcd.print("C");

    /* mise à jour de la date */
    date = (date + intervalle / 1000);  
  }
}
