/**
  Mesures de températures avec trois capteurs DS18B20 GROVE
  Les mesures sont envoyées sur la liaison série et affichées sur un écran LCD i2c non Grove
  © Stéphane LAURENT Lycée Valin (17)
 */
 
/* Inclure les bibliothèques */
#include <OneWire.h>
#include <DallasTemperature.h>
#include <LiquidCrystal_I2C.h>   // inclure la bibliothèque I2C
 
/* Création de l'objet OneWire et sensors */
 
OneWire capteur1(6);   // Création d'un objet One Wire sur la broche 6  => température T1
OneWire capteur2(5);   // Création d'un objet One Wire sur la broche 5  => température T2
OneWire capteur3(7);   // Création d'un objet One Wire sur la broche 7  => température T3
 
// Indiquer la référence OneWire à la bibliothèque Dallas Temperature.
DallasTemperature sensors1(&capteur1);
DallasTemperature sensors2(&capteur2); 
DallasTemperature sensors3(&capteur3);

/* Ecran LCD  */
LiquidCrystal_I2C lcd(0x27,16,2);   // adresse i2c , nombre de colonnes, nombre de lignes de l'écran 

/* Pour faire des mesures à intervalle régulier */
 
unsigned long tempsPrecedent = 0;
unsigned long date = 0;     // date de la mesure
float intervalle = 2000;    // durée entre deux mesures en ms 

/* Calibration des thermomètres (facultatif) */
float calibration1 = 0;  // valeur de la calibration du thermomètre 1
float calibration2 = 0;  // valeur de la calibration du thermomètre 2
float calibration3 = 0;  // valeur de la calibration du thermomètre 3

void setup() {
  lcd.init();                   // initialisation du LCD
  lcd.backlight();              // active le rétroéclairage
  lcd.print("  Thermometre") ;  //affichage d'un message sur l'ecran
  lcd.setCursor(0, 1);          // mettre le curseur à la première colonne, deuxième ligne
  lcd.print("Lycee Valin (17)") ; 
  
  Serial.begin(115200);  // choix de la vitesse
 
  sensors1.begin();
  sensors2.begin();
  sensors3.begin();

  Serial.println("Ok");   // envoyer à Python pour l'informer que l'initialisation est terminée
  delay(100);
  Serial.println(3);      // envoie à Python le nombre de thermomètres
  delay(100);

}
 
void loop(){
  unsigned long tempsCourant = millis();  
 
  if (tempsCourant - tempsPrecedent >= intervalle) {
      tempsPrecedent = tempsCourant;
 
      /* Demande la température aux capteurs */
 
      sensors1.requestTemperatures(); 
      float temperature_1 = sensors1.getTempCByIndex(0) + calibration1;  // obtenir la température 1 en degré

      sensors2.requestTemperatures(); 
      float temperature_2 = sensors2.getTempCByIndex(0) + calibration2;  // obtenir la température 2 en degré

      sensors3.requestTemperatures();
      float temperature_3 = sensors3.getTempCByIndex(0) + calibration3;  // obtenir la température 3 en degré

      /* envoie la date sur la liaison série  */
      Serial.print(date);
      Serial.print(" ");   // les données sont séparées par des espaces.
 
      /* envoie les températures sur la liaison série  */
      
      Serial.print(int(temperature_1*10));
      Serial.print(" ");   // les données sont séparées par des espaces.

      Serial.print(int(temperature_2*10));
      Serial.print(" ");   // les données sont séparées par des espaces.

      Serial.println(int(temperature_3*10));
      
 
      /* Affiche les températures sur l'écran lcd */
 
      lcd.clear();   // effacer l'écran
 
      lcd.setCursor(0,0);   // mettre le curseur à la première colonne, première ligne
      lcd.print(temperature_1, 1);
      lcd.print((char)223);   // symbole °
      lcd.print("C"); 
      
      lcd.setCursor(9,0);   // mettre le curseur à la 10ème colonne, première ligne
      lcd.print(temperature_2, 1);
      lcd.print((char)223);   // symbole °
      lcd.print("C"); 
 
      lcd.setCursor(5,1);   // mettre le curseur à la 6ème colonne, deuxième ligne
      lcd.print(temperature_3, 1);
      lcd.print(" "); 
      lcd.print((char)223);   // symbole °
      lcd.print("C");  

      /* mise à jour de la date */
      date = (date + intervalle / 1000);       
  }
}
