// ************************************************************
//
//                     Mini spectro - Capteur as7341
//
//   A utiliser avec l'interface graphique "minispectro.exe"
//
//            Stéphane LAURENT - Lycée Valin (17)
//
//*************************************************************


//*********************APPEL DES BIBLIOTHEQUES*********************************************************************

#include <LiquidCrystal_I2C.h>    //appel de la bibliotheque cristaux liquide pour l'ecran  

#include <Adafruit_AS7341.h>              //appel de la bibliotheque du capteur             

Adafruit_AS7341 as7341;                   //creation de l'objet sensor de classe AS7341

LiquidCrystal_I2C lcd(0x27, 16, 2); //creation de l'objet lcd de classe LiquidCrystal_I2C

//******************* DEFINITION DES CONSTANTES *********************************************************************************************************

int intensiteSeuil = 150 ;     //Seuil d'intensité pour la LED
uint16_t readings[12];

// definition des variables contenant des mesures
float intensities [8] ;   // intensite lumineuse mesuree par le capteur. Tableau contenant les valeurs aux 8 longueurs d'onde.
float blankIntensities [8]; // Tableau des intensite mesurees sur le blanc.
float absIntensities [8]; // Tableau des absorbances aux 8 longueurs d'onde.

//definition des pins hors ecran LCD
const int ledPin = 3 ;    //on se place sur un port PWM
int ledIntensity = 1 ;     //intensité de la LED à calibrer
bool ledOn = false ;      // etat de la LED, quand ledOn = false, la l'état de la LED est éteint

bool channel_415nm = false ;   //booléens utilisés pour la fonction de changement de mode
bool channel_445nm = false ;
bool channel_480nm = false ;
bool channel_515nm = false ;
bool channel_555nm = false ;
bool channel_590nm = false ;
bool channel_630nm = false ;
bool channel_680nm = false ;

//******************* SETUP **************************************************************************************//

void setup() {

  lcd.init() ;               // initialisation du LCD
  lcd.backlight() ;          // active le rétroéclairage
  Serial.begin(9600) ;       // Mise en route du port Serie (communication avec l'ordinateur). On precise la vitesse de communication
  Serial.flush();            // On vide le tampon de réception par précaution
  pinMode(ledPin, OUTPUT) ;  // mode de la pin a laquelle est connectee la led en OUTPUT

  // capteur as7341
  if (!as7341.begin()){
    Serial.println("Impossible de trouver le capteur AS7341");
    while (1) { delay(10); }
  }

  as7341.setATIME(99); // valeur init 100
  as7341.setASTEP(999); // valeur init 599
  as7341.setGain(AS7341_GAIN_256X);
  
//  //Integration time = (ATIME + 1) x (ASTEP + 1) x 2.78µs
//  //Set the value of register ATIME(1-255), through which the value of Integration time can be calculated. The value represents the time that must be spent during data reading.
//  as7341.setAtime(29);
//  //Set the value of register ASTEP(0-65534), through which the value of Integration time can be calculated. The value represents the time that must be spent during data reading.
//  as7341.setAstep(599);
//  //Set gain value(0~10 corresponds to X0.5,X1,X2,X4,X8,X16,X32,X64,X128,X256,X512)
//  as7341.setAGAIN(7);
//  //Enable LED
//  //as7341.enableLed(true);
//  //Set pin current to control brightness (1~20 corresponds to current 4mA,6mA,8mA,10mA,12mA,......,42mA)
//  //as7341.controlLed(10);
   
//*******************************************************************************************************************//

  lcd.clear() ;
  switchOffLed() ;

  lcd.print("Initialisation...") ;  //affichage d'un message sur l'ecran

  ledCalibration() ;

  affichageInit();           // affichage initial lorsque le spectro est prêt

  Serial.println("A");      // message envoyé sur la liaison série pour l'informer que l'initialisation est terminée
}

//******************* LOOP s'execute en boucle en permanence ******************************************************************************************//

void loop() {

  if ( Serial.available() ) {
    String message = Serial.readString();  // lit la valeur envoyée et l’enregistre dans la variable "message" »
    message.trim(); //suprime les espaces et les caractère \r\n. Evite une erreur si utilisation avec le moniteur série (pas indispensable avec l'interface graphique)
    
    if (message == "blanc") {
      takeBlank() ;                    // faire le blanc
      affichageInit();
    }
    
    if (message == "spectre") {
      lcd.clear() ;                    // on efface l'ecran LCD
      lcd.print("    Spectre") ;       // on affiche "Spectre d'absorption" sur l'ecran LCD
      lcd.setCursor(2, 1);
      lcd.print("d'absorption") ;
      mesureAbsorbances();             // faire le spectre d'absorbance
      printSerialAbs();
      affichageInit();
    }
    
    if (message.indexOf(" nm") > 0) { // choix de la longueur d'onde

      choix_longueur_onde(message);
      affichageInit();
    }

    if (message == "absorbance") {
      lcd.clear() ;                    // on efface l'ecran LCD
      lcd.print("    Mesure de") ;     // on affiche "Spectre d'absorption" sur l'ecran LCD
      lcd.setCursor(2, 1);
      lcd.print("l'absorbance") ;
      mesureAbsorbances();            // mesure de l'absorbance
      printSimpleAbs();
      affichageInit();
    }
  }
  delay(100);
}

//******************* DEFINITION DES FONCTIONS UTILISEES ***************************************************************************************************//


void affichageInit() {              // Affichage initial lorsque le spectro est prêt
  lcd.clear() ;
  lcd.print("  Mini Spectro") ;
  lcd.setCursor(0, 1);              // mettre le curseur sur la deuxième ligne
  lcd.print("Lycee Valin (17)");
}
// choix de la longueur d'onde

void choix_longueur_onde(String longueur_onde) {

  channel_415nm = false ;   
  channel_445nm = false ;
  channel_480nm = false ;
  channel_515nm = false ;
  channel_555nm = false ;
  channel_590nm = false ;
  channel_630nm = false ;
  channel_680nm = false ;

  if (longueur_onde == "415 nm") {
    channel_415nm = true;
  }
  if (longueur_onde == "445 nm") {
    channel_445nm = true;
  }
  if (longueur_onde == "480 nm") {
    channel_480nm = true;
  }
  if (longueur_onde == "515 nm") {
    channel_515nm = true;
  }
  if (longueur_onde == "555 nm") {
    channel_555nm = true;
  }
  if (longueur_onde == "590 nm") {
    channel_590nm = true;
  }
  if (longueur_onde == "630 nm") {
    channel_630nm = true;
  }
  if (longueur_onde == "680 nm") {
    channel_680nm = true;
  }

  lcd.clear() ;                    // on efface l'ecran LCD
  lcd.print(" Longueur d'onde") ;
  lcd.setCursor(5, 1);  // mettre le curseur à la colonne 6, ligne 2
  lcd.print(longueur_onde);
  delay(1000);

}

void mesureAbsorbances() {
  takeMeasure() ;
  computeAbsorbance(intensities, blankIntensities) ;
}

void printSimpleAbs() { // envoyer sur le port série l'absorbance à la longueur d'onde sélectionnée

  if (channel_415nm == true) {

    Serial.println(int(absIntensities [0] * 1000));
  }
  if (channel_445nm == true) {
    Serial.println(int(absIntensities [1] * 1000));
  }
  if (channel_480nm == true) {
    Serial.println(int(absIntensities [2] * 1000));
  }
  if (channel_515nm == true) {
    Serial.println(int(absIntensities [3] * 1000));
  }
  if (channel_555nm == true) {
    Serial.println(int(absIntensities [4] * 1000));
  }
  if (channel_590nm == true) {
    Serial.println(int(absIntensities [5] * 1000));
  }
  if (channel_630nm == true) {
    Serial.println(int(absIntensities [6] * 1000));
  }
  if (channel_680nm == true) {
    Serial.println(int(absIntensities [7] * 1000));
  }
  lcd.clear() ;
  lcd.print(" Mesure terminee") ;
  delay(1000) ;
}

// ------------------------------------------------------------------------------------------------------------
// Envoyer les valeurs des absorbances sur le port série

void printSerialAbs() {
  for (int i = 0; i <= 6; i++) {
    Serial.print(int(absIntensities [i] * 1000)); // multiplier par 1000 pour envoyer uniquement des nombres entiers
    Serial.print(" "); // séparer les valeurs par un espace
  }
  Serial.println(int(absIntensities [7] * 1000));

  lcd.clear() ;
  lcd.print("Spectre termine") ;
  delay(1000) ;
}

//------------------------------------------------------------------------
//la fonction takeMeasure enregistre les intensites lumineuses mesurees pour chaque longueur d'onde

void takeMeasure() {

  switchOnLed();                // on allume la LED
  delay(1000) ;
  
  // Read all channels at the same time and store in as7341 object
  if (!as7341.readAllChannels(readings)){
    Serial.println("Error reading all channels!");
  }  
  
  switchOffLed() ;              // on eteint la LED
  
  //on affecte les valeurs de chaque longueur d'onde aux 8 variables associees
  intensities [0] = (readings[0]) ;  
  intensities [1] = (readings[1]) ;
  intensities [2] = (readings[2]) ;
  intensities [3] = (readings[3]) ;
  intensities [4] = (readings[6]) ;
  intensities [5] = (readings[7]) ;
  intensities [6] = (readings[8]) ;
  intensities [7] = (readings[9]) ;
  delay(100);                  // on attend 100ms
}

//------------------------------------------------------------------------------------------------------------

// la fonction takeBlank permet de faire le blanc 

void takeBlank() {
  lcd.clear() ;                     // on efface l'ecran LCD
  lcd.print("Reglage du zero") ;    // on affiche "Réglage du zéro" sur l'ecran LCD
  delay(500) ;                      // on attend 0.5 s

  // On fait la mesure ici :
  takeMeasure();
  for (int k = 0; k < 8; k++) {
    blankIntensities [k] = intensities [k] ;  // on affecte a chaque case du tableau blankIntensities les valeurs d'intensite lumineuses mesurees a chaque longueur d'onde
    Serial.println(blankIntensities [k]);
  }

  lcd.setCursor(4, 1);
  lcd.print("termine !") ;
  switchOffLed() ;

  Serial.println("A"); // Envoyer "A" sur le port série pour indiquer que le blanc est terminé
  delay(1000) ;
}

///------------------------------------------------------------------------------------------------------------

//la fonction computeAbsorbance permet de calculer l'absorbance à partir des intensités luminseuses mesurées

void computeAbsorbance(float * newIntensities, float * refIntensities) {
  for (int k = 0; k < 8; k++) {
    absIntensities [k] = log10(refIntensities[k] / newIntensities[k])  ;       
  }
}

// La fonction suivante permet d'allumer la LED blanche
void switchOnLed() {
  analogWrite(ledPin, ledIntensity) ; // on applique une tension de 5V  sur la pin de la LED, à une fréquence qui est égale à ledIntensity
  ledOn = true ;                     // l'état de la led passe à true : la LED est allumée
}

// La fonction suivante permet d'éteindre la LED blanche
void switchOffLed() {
  analogWrite(ledPin, 0) ;          // on applique une tension nulle sur la pin de la LED
  ledOn = false ;                   // l'état de la LED passe à false : la LED est éteinte

}

void ledCalibration() {                     //Fonction qui permet de calibrer la LED au démarrage de l'appareil et donc de s'affranchir des différence qui peuvent exister entre les composants
  int violet = 0 ;
  ledIntensity = 0 ;                        //Cette valeur est proportionnellement liée au flux lumineux émis par la diode

  while (violet < intensiteSeuil) {                   //On cherche à atteindre une certaine intensité lumineuse lue par le capteur sur le canal Violet, ici 500. Tant que cette valeur n'est pas atteinte au augmente ledIntensity
    analogWrite(ledPin, ledIntensity) ;
    delay(5) ;
    as7341.readAllChannels(readings) ;
    violet = readings[0] ;
    ledIntensity ++ ;                                 //On incrémente l'intensité perçue par la LED
  }
  switchOffLed() ;
}
