
#-------Importation des bibliothèques -----------

import matplotlib.pyplot as plt     # importation d'un sous module (pyplot) de la bibliothèque matplotlib sous le nom plt
import numpy as np                  # Importation du module numpy afin de lire le contenu du fichier csv et d'utiliser des tableaux
import modelisation                 # pour faire de la modélisation 


# ------- Saisir les mesures expérimentales dans des listes -------

x = [0, 1e-3, 2e-3, 3e-3, 4e-3, 5e-3, 6e-3, 7e-3]         #  saisir les valeurs de la grandeur en abscisse
y = [0, 0.221, 0.440, 0.665, 1.250, 1.105, 1.327, 1.550]  #  saisir les valeurs de la grandeur en ordonnée


# ------ Saisir les mesures expérimentales dans un tableau numpy ------
'''
x = np.array([0, 1e-3, 2e-3, 3e-3, 4e-3, 5e-3, 6e-3, 7e-3])          #  saisir les valeurs de la grandeur en abscisse
y = np.array([0, 0.221, 0.440, 0.665, 1.250, 1.105, 1.327, 1.550])   #  saisir les valeurs de la grandeur en abscisse
'''

# --- Importation des mesures à partir d'un fichier CSV ---
'''
x, y = np.loadtxt("mesures.csv", delimiter =',', skiprows = 2, unpack = True)
'''
    # Dans cet exemple, les données sont séparées par des "," . On commence à lire à partir de la troisième ligne (skiprows=2)
    # Les données se retrouveront dans deux tableaux Numpy (x et y)
    # Si on préfère utiliser des listes plutôt que des tableaux Numpy, il suffit de les convertir : 
    #    x = x.tolist()     
    #    y = y.tolist()


#---------- Caractéristiques du graphique -------

plt.plot(x, y, color='red', marker='+', linestyle = 'none', markersize = 15, markeredgewidth = 2) # Affiche des points aux coordonnées x, y : linestyle = 'none' --> ne pas relier les points par une ligne : markersize --> taille d'un point : markeredgewidth = 2 --> épaisseur du trait         
plt.xlabel("Grandeur en abscisse (unité)", fontsize = 12, fontweight = 'bold', labelpad = 15)     # Nommer l'axe des abscisses
plt.ylabel("Grandeur en ordonnée (unité)", fontsize = 12, fontweight = 'bold', labelpad = 15)     # Nommer l'axe des ordonnées
plt.title("Titre du graphique", color = "black", fontsize = 20, fontweight = 'bold', pad = 20)    # fontsize = 20 --> taille caractères : fontweight = 'bold' --> en gras

#---------- Paramètres facultatifs du graphique ----------

plt.grid()  # Afficher un quadrillage
plt.xlim(0) # fixe la plus petite graduation sur x
plt.ylim(0) # fixe la plus petite graduation sur y
#plt.axis([Xmin, Xmax, Ymin, Ymax])  # limites du graphique
#plt.gca().yaxis.set_ticks_position('right') # placer l'axe des ordonnés à droite
#plt.axis('equal') # pour avoir un repère orthonormé

#--------------- Modélisation ------------------

modelisation.modele("lineaire",x ,y) # modèles disponibles : "lineaire", "affine", "parabole", "exp_croissante", "exp_decroissante", "double_affine"


#----------- Afficher le graphique ------------
plt.show() 




''' ---------- Options facultatives pour la modélisation --------------------------------------------------------------'''
#
# structure : modelisation.modele("nom du modèle", grandeur en abscisse, grandeur en ordonnée, paramètres facultatifs )
#
# Exemple : modelisation.modele("affine", x, y, color = "red", linestyle = 'solid', linewidth = 2.5)
#
# color = '#FF0000' ou color = 'red' --> permet de définir la couleur de la modélisation (par défaut : color = 'black' et color = 'mediumblue' pour le modèle 'double_affine')
# color2 = 'blue' --> permet de définir la couleur de la modélisation pour la 2ème droite affine lorsqu'on utilise le modèle "double_affine" (par défaut : color2 = 'green'
#
# linestyle --> permet de définir le style de la modélisation. Choix possibles : "solid", "dotted", "dashed" et "dashdot". (par défaut : linestyle = 'dashed'
#    'solid'   --> ligne continue ( __________ )
#    'dotted'  --> ligne constituée de points ( .......... )
#    'dashed'  --> ligne en pointillé (----------)
#    'dashdot' --> ligne alternant un point et un trait ( -.-.-.-.- )
#
# linewidth = 2 --> épaisseur du trait de la modélisation (par défaut : linewidth = 1.5)


''' ---------- Récupérer les données de modélisation ---------- '''

# Pour un modèle linéaire (y = ax) :
# a = modelisation.modele("lineaire", x, y) --> la variable 'a' contient le coefficient directeur

# Pour un modèle affine (y = ax + b) :
# a, b = modelisation.modele("affine", x, y) --> la variable 'a' contient le coefficient directeur
#                                            --> la variable 'b' contient l'ordonnée à l'origine

# Pour un modèle parabolique (y = ax² + bx + c) :
# a, b, c = modelisation.modele("parabole", x, y) 

# Pour un modèle exponentielle croissante (y = a(1 - exp(-bx)) : 
# a, b = modelisation.modele("exp_croissante", x, y)

# Pour un modèle exponentielle décroissante (y = a exp(-bx) : 
# a, b = modelisation.modele("exp_decroissante", x, y)

# ATTENTION :
# 1) il n'est pas possible de récupérer les données de modélisation pour le modèle 'double_affine'.
# 2) La fonction 'lasso', ne met pas à jour les données de modélisation


''' ----------- Options accessibles avec le clavier ------------------------------------------------------------------'''

# Touche 'Suppr' ou 'Delete' --> Supprime la modélisation
# Touche 'espace' du clavier --> Affiche un réticule
# Touche 'm' du clavier      --> Affiche ou masque la légende
# Touche 'g' du clavier      --> Affiche ou masque le quadrillage du graphique
# Ctrl + 'c'                 --> Copie le graphique dans le presse-papiers